<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Plugin\Customer\Model;

use Magento\Customer\Model\Session;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Plugin assign company customer group id to customers after shared catalog was changed.
 */
class SessionPlugin
{
    /**
     * Get customer group id.
     *
     * @param Session $subject
     * @param int $groupId
     * @return int
     */
    public function afterGetCustomerGroupId(Session $subject, $groupId)
    {
        try {
            if ($subject->getCustomerData()) {
                if ($groupId != $subject->getCustomerData()->getGroupId()) {
                    $customerGroupId = $subject->getCustomerData()->getGroupId();
                    $subject->setCustomerGroupId($customerGroupId);
                    return $customerGroupId;
                }
            }
            return $groupId;
        } catch (NoSuchEntityException $e) {
            return $groupId;
        }
    }
}
