<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Plugin\Company\Model\ResourceModel\Company\Grid;

/**
 * Add customer_group_code column to companies grid collection.
 */
class CollectionPlugin
{
    /**
     * Add customer_group_code column to companies grid collection before loading.
     *
     * @param \Magento\Company\Model\ResourceModel\Company\Grid\Collection $subject
     * @param bool $printQuery [optional]
     * @param bool $logQuery [optional]
     * @return array
     */
    public function beforeLoad(
        \Magento\Company\Model\ResourceModel\Company\Grid\Collection $subject,
        $printQuery = false,
        $logQuery = false
    ) {
        $subject->getSelect()
            ->joinLeft(
                ['customer_group' => $subject->getTable(
                    'customer_group'
                )],
                'main_table.customer_group_id = customer_group.customer_group_id',
                ['customer_group_code']
            );

        return [$printQuery, $logQuery];
    }
}
