<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\CatalogPermissions\Block\Adminhtml\Catalog\Category\Tab\Permissions;

use Magento\CatalogPermissions\Block\Adminhtml\Catalog\Category\Tab\Permissions\Row;
use Magento\SharedCatalog\Model\State;

/**
 * Plugin model for catalog category permission row block
 */
class RowPlugin
{
    /**
     * @var State
     */
    private $sharedCatalogConfig;

    /**
     * @param State $sharedCatalogConfig
     */
    public function __construct(
        State $sharedCatalogConfig
    ) {
        $this->sharedCatalogConfig = $sharedCatalogConfig;
    }

    /**
     * Force websites selector to show for edit.
     *
     * By default website selector is hidden if only one store is configured.
     * Category permission is auto generated for a new category for all websites if shared catalog is enabled.
     * Showing website selector gives visibility of permission scope.
     *
     * @param Row $subject
     * @param bool $canEdit
     * @return bool
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterCanEditWebsites(
        Row $subject,
        bool $canEdit
    ): bool {
        if ($this->sharedCatalogConfig->isEnabled()) {
            $canEdit = true;
        }
        return $canEdit;
    }
}
