<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Catalog\Model\Category;

use Magento\Catalog\Model\Category\DataProvider;
use Magento\SharedCatalog\Model\State;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;
use Magento\Store\Model\Website;
use Magento\Ui\Component\Form\Element\DataType\Text;
use Magento\Ui\Component\Form\Element\Select;
use Magento\Ui\Component\Form\Field;

class CategoryFormModifier
{
    /**
     * @param CollectionFactory $websiteCollectionFactory
     * @param State $sharedCatalogConfig
     */
    public function __construct(
        private readonly CollectionFactory $websiteCollectionFactory,
        private readonly State $sharedCatalogConfig
    ) {
    }

    /**
     * Shows website for category permissions if shared catalog is enabled regardless if there is only one website.
     *
     * @param DataProvider $subject
     * @param array $result
     * @return mixed
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @see \Magento\SharedCatalog\Plugin\CatalogPermissions\Block\Adminhtml\Catalog\Category\Tab\Permissions\RowPlugin
     */
    public function afterPrepareMeta(DataProvider $subject, $result)
    {
        $websiteConfig = $result['category_permissions']['children']['category_permissions_container']['children']
        ['permissions']['children']['record']['children']['website_id']['arguments']['data']['config'] ?? false;
        if ($this->sharedCatalogConfig->isEnabled()
            && $websiteConfig
            && isset($websiteConfig['formElement']) && $websiteConfig['formElement'] !== Select::NAME
        ) {
            $websiteConfig = array_replace_recursive(
                $websiteConfig,
                [
                    'label' => __('Website'),
                    'dataType' => Text::NAME,
                    'formElement' => Select::NAME,
                    'componentType' => Field::NAME,
                    'sortOrder' => 10,
                    'disabled' => true,
                    'options' => [
                        [
                            'value' => '',
                            'label' => __('-- Please select --')
                        ],
                        [
                            'label' => __('All Websites'),
                            'value' => -1,
                        ],
                        ...array_map(
                            fn (Website $website) => [
                                'label' => $website->getName(),
                                'value' => $website->getId(),
                            ],
                            $this->websiteCollectionFactory->create()->getItems()
                        ),
                    ],
                    'validation' => [
                        'required-entry' => true,
                        'validate-unique-category-permission' => true
                    ],
                ]
            );
            $result['category_permissions']['children']['category_permissions_container']['children']['permissions']
            ['children']['record']['children']['website_id']['arguments']['data']['config'] = $websiteConfig;
        }
        return $result;
    }
}
