<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Backend\Block\Widget\Grid\Column\Multistore;

use Magento\Backend\Block\Widget\Grid\Column\Multistore;
use Magento\SharedCatalog\Block\Widget\Grid\Column\Renderer\CustomerGroup;

/**
 * Plugin for modifying renderer types
 */
class AddCustomRendererTypes
{
    /**
     * Change renderer for type "option"
     *
     * @param \Magento\Backend\Block\Widget\Grid\Column\Multistore $subject
     */
    public function beforeGetRenderer(Multistore $subject)
    {
        $subject->setRendererType('options', CustomerGroup::class);
    }
}
