<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Backend\Block\Adminhtml\Store;

use Magento\Backend\Model\Auth\Session;
use Magento\SharedCatalog\Block\Adminhtml\Store\Switcher;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;

/**
 * Plugin for store switch permission based on role
 */
class SwitcherRolePermissions
{
    /**
     * @var array
     */
    private $allWebsiteIds = [];

    /**
     * @param Session $backendAuthSession
     * @param CollectionFactory $websiteCollectionFactory
     */
    public function __construct(
        private readonly Session $backendAuthSession,
        private readonly CollectionFactory $websiteCollectionFactory
    ) {
    }

    /**
     * Remove 'All Stores' for website restricted users
     *
     * @param Switcher $subject
     * @param array $result
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetStoreOptionsAsArray(
        Switcher $subject,
        array $result
    ):array {
        $role = $this->backendAuthSession->getUser()->getRole();
        $allowedWebsites = $role->getGwsWebsites() ?? [];
        if (!$role->getGwsIsAll() &&
            count(array_diff($this->getAllWebsiteIds(), $allowedWebsites)) !== 0) {

            if ($role->getGwsStoreGroups()) {
                $result = array_filter($result, function ($item) use ($role) {
                    return in_array($item['id'], $role->getGwsStoreGroups());
                });
            }
        }

        return array_values($result);
    }

    /**
     * Get all website ids excluding admin store.
     *
     * @return array
     */
    private function getAllWebsiteIds(): array
    {
        if (!count($this->allWebsiteIds)) {
            $websites = $this->websiteCollectionFactory->create()->getAllIds();
            $websites = array_filter($websites);
            $this->allWebsiteIds = $websites;
        }

        return  $this->allWebsiteIds;
    }
}
