<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class IsActive
 */
class SharedCatalogType implements OptionSourceInterface
{
    /**
     * @var \Magento\SharedCatalog\Model\SharedCatalog
     */
    protected $sharedCatalog;

    /**
     * IsActive constructor.
     *
     * @param \Magento\SharedCatalog\Model\SharedCatalog $sharedCatalog
     */
    public function __construct(\Magento\SharedCatalog\Model\SharedCatalog $sharedCatalog)
    {
        $this->sharedCatalog = $sharedCatalog;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $availableOptions = $this->sharedCatalog->getAvailableTypes();
        $options = [];
        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}
