<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model\ResourceModel;

use Magento\Catalog\Model\ResourceModel\CategoryProduct as CategoryProductResource;

class CategoryProductLink
{
    /**
     * @param CategoryProductResource $categoryProductResource
     */
    public function __construct(
        private readonly CategoryProductResource $categoryProductResource
    ) {
    }

    /**
     * Retrieve unique category ids for provided product ids
     *
     * @param int[] $productIds
     * @return int[]
     */
    public function getCategoryIds(array $productIds): array
    {
        $connection = $this->categoryProductResource->getConnection();
        $select = $connection->select()
            ->from($this->categoryProductResource->getMainTable(), ['category_id'])
            ->where('product_id IN (?)', $productIds, \Zend_Db::INT_TYPE)
            ->distinct(true);
        $ids = $connection->fetchCol($select);

        return array_map('intval', $ids);
    }
}
