<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model;

use Magento\Catalog\Api\Data\TierPriceInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Validate Tire Price data on request
 */
class PriceRequestValidator
{
    /**
     * @var array
     */
    private array $requiredFields;

    /**
     * Constructor
     *
     * @param array $requiredFields
     */
    public function __construct(
        array $requiredFields = []
    ) {
        $this->requiredFields = $requiredFields;
    }

    /**
     * Validate tire price request data
     *
     * @param TierPriceInterface[] $tierPrices
     * @throws LocalizedException
     */
    public function validate(array $tierPrices): void
    {
        foreach ($tierPrices as $tierPrice) {
            foreach ($this->requiredFields as $field => $method) {
                if ($tierPrice->$method() === null) {
                    $phrase = __(
                        'The validation of price request has failed: "%1" is required field.',
                        [$field]
                    );
                    throw new LocalizedException($phrase);
                }
            }
        }
    }
}
