<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

namespace Magento\SharedCatalog\Model\Customer\Source\Collection;

use Magento\Customer\Api\Data\GroupInterface;

/**
 * Join shared catalog table to the customer group collection.
 */
class Group extends \Magento\Customer\Model\ResourceModel\Group\Collection
{
    /**
     * Join shared catalog table to the customer group collection.
     *
     * @param bool $catalogGroups [optional]
     * @param bool $excludeNotLogged [optional]
     * @return $this
     */
    public function joinSharedCatalogTable($catalogGroups = false, $excludeNotLogged = true)
    {
        if ($excludeNotLogged) {
            $this->addFieldToFilter('main_table.customer_group_id', ['neq' => GroupInterface::NOT_LOGGED_IN_ID]);
        }
        $this->getSelect()->joinLeft(
            ['shared_catalog' => $this->getTable('shared_catalog')],
            'main_table.customer_group_id = shared_catalog.customer_group_id',
            [
                'shared_catalog_id' => 'shared_catalog.entity_id',
                'shared_catalog_name' => 'shared_catalog.name'
            ]
        );
        $this->getSelect()->where('shared_catalog.entity_id IS' . ($catalogGroups ? ' NOT' : '') . ' NULL');
        $this->addOrder('main_table.customer_group_code', \Magento\Framework\Data\Collection::SORT_ORDER_ASC);

        return $this;
    }
}
