<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Model\Configure\Category\Tree;

use Magento\Framework\Data\Tree\Node;

/**
 * Prepare nodes data for tree of assigned categories.
 */
class AssignedRenderer extends Renderer
{
    /**
     * Get node data as array.
     *
     * @param Node $node
     * @param int $level Node level in tree sructure [optional]
     * @return array
     */
    protected function getNodeDataAsArray($node, $level = 0)
    {
        $item = [];

        $children = [];
        if ($node->hasChildren()) {
            foreach ($node->getChildren() as $child) {
                $childData = $this->getNodeDataAsArray($child, $level + 1);
                if (count($childData)) {
                    $children[] = $childData;
                }
            }
        }

        if (count($children) || $node->getIsChecked()) {
            $item = $this->prepareNodeData($node, $item);
            $item['children'] = $children;
        }

        return $item;
    }
}
