<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Controller\Adminhtml\SharedCatalog;

use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\SharedCatalog\Model\Form\Storage\CompanyFactory as CompanyStorageFactory;
use Magento\SharedCatalog\Model\Form\Storage\Company\Builder as CompanyStorageBuilder;
use Magento\SharedCatalog\Model\Form\Storage\UrlBuilder;

/**
 * Shared catalog Companies
 */
class Companies extends AbstractAction implements HttpGetActionInterface
{
    /**
     * @var CompanyStorageFactory
     */
    protected $companyStorageFactory;

    /**
     * @var CompanyStorageBuilder
     */
    protected $companyStorageBuilder;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param \Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface $sharedCatalogRepository
     * @param CompanyStorageFactory $companyStorageFactory
     * @param CompanyStorageBuilder $companyStorageBuilder
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface $sharedCatalogRepository,
        CompanyStorageFactory $companyStorageFactory,
        CompanyStorageBuilder $companyStorageBuilder
    ) {
        parent::__construct($context, $resultPageFactory, $sharedCatalogRepository);
        $this->companyStorageFactory = $companyStorageFactory;
        $this->companyStorageBuilder = $companyStorageBuilder;
    }

    /**
     * {@inheritdoc}
     */
    public function execute()
    {
        /** @var \Magento\SharedCatalog\Model\Form\Storage\Company $companyStorage */
        $companyStorage = $this->companyStorageFactory->create([
            'key' => $this->getRequest()->getParam(UrlBuilder::REQUEST_PARAM_CONFIGURE_KEY)
        ]);
        $this->companyStorageBuilder->build($companyStorage, $this->getSharedCatalog());

        return $this->createResultPage();
    }

    /**
     * {@inheritdoc}
     */
    protected function createResultPage()
    {
        $resultPage = parent::createResultPage();
        $resultPage->getConfig()->getTitle()->prepend($this->getSharedCatalog()->getName());
        return $resultPage;
    }
}
