<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2018 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Api;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class for processing Shared Catalog duplication actions
 *
 * @api
 */
interface SharedCatalogDuplicationInterface
{
    /**
     * Add products into the shared catalog by catalog ID and array of the products sku.
     *
     * @param int $sharedCatalogId
     * @param string[] $productsSku
     * @return void
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function assignProductsToDuplicate(int $sharedCatalogId, array $productsSku): void;
}
