<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api;

use Magento\SharedCatalog\Api\Data\SharedCatalogInterface;

/**
 * Shared catalog prices actions.
 * @api
 * @since 100.0.0
 */
interface PriceManagementInterface
{
    /**
     * Save product tier prices.
     *
     * @param SharedCatalogInterface $sharedCatalog
     * @param array $prices
     * @return $this
     */
    public function saveProductTierPrices(SharedCatalogInterface $sharedCatalog, array $prices);

    /**
     * Delete product tier prices.
     *
     * @param SharedCatalogInterface $sharedCatalog
     * @param array $skus
     * @return $this
     */
    public function deleteProductTierPrices(SharedCatalogInterface $sharedCatalog, array $skus);
}
