<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api;

/**
 * Shared catalog products actions.
 * @api
 * @since 100.0.0
 */
interface CategoryManagementInterface
{
    /**
     * Return the list of categories in the selected shared catalog.
     *
     * @param int $id
     * @return int[]
     */
    public function getCategories($id);

    /**
     * Add categories into the shared catalog.
     *
     * @param int $id
     * @param \Magento\Catalog\Api\Data\CategoryInterface[] $categories
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function assignCategories($id, array $categories);

    /**
     * Remove the specified categories from the shared catalog.
     *
     * @param int $id
     * @param \Magento\Catalog\Api\Data\CategoryInterface[] $categories
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function unassignCategories($id, array $categories);
}
