<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * **********************************************************************
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Config\Model\ConfigFactory;
use Magento\Framework\App\Area;
use Magento\Framework\Config\ScopeInterface;
use Magento\Framework\DataObject;
use Magento\Framework\MessageQueue\ConsumerFactory;
use Magento\SharedCatalog\Model\Config as SharedCatalogConfig;
use Magento\TestFramework\Fixture\RevertibleDataFixtureInterface;
use Magento\TestFramework\Helper\Bootstrap;

class EnableSharedCatalog implements RevertibleDataFixtureInterface
{
    /**
     * @param ScopeInterface $scope
     * @param ConfigFactory $configFactory
     * @param ConsumerFactory $consumerFactory
     */
    public function __construct(
        private readonly ScopeInterface $scope,
        private readonly ConfigFactory $configFactory,
        private readonly ConsumerFactory $consumerFactory
    ) {
    }

    /**
     * @inheritdoc
     */
    public function apply(array $data = []): ?DataObject
    {
        $data['website'] ??= null;
        $this->toggleSharedCatalog(true, $data['website']);

        return new DataObject($data);
    }

    /**
     * @inheritdoc
     */
    public function revert(DataObject $data): void
    {
        $this->toggleSharedCatalog(false, $data['website']);
    }

    /**
     * Toggle shared catalog state
     *
     * @param bool $state
     * @param int|string|null $website
     * @return void
     */
    private function toggleSharedCatalog(bool $state, int|string|null $website): void
    {
        $currentScope = $this->scope->getCurrentScope();
        $this->scope->setCurrentScope(Area::AREA_ADMINHTML);
        $config = $this->configFactory->create();
        $config->setDataByPath(SharedCatalogConfig::CONFIG_SHARED_CATALOG, $state);
        if ($website) {
            $config->setWebsite($website);
        }
        $config->save();
        $this->scope->setCurrentScope($currentScope);
        Bootstrap::getInstance()->reinitialize();

        $permissionsConsumer = $this->consumerFactory->get('sharedCatalogUpdateCategoryPermissions');
        $permissionsConsumer->process(100);
    }
}
