<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\InvalidArgumentException;
use Magento\Framework\DataObject;
use Magento\SharedCatalog\Api\CategoryManagementInterface;
use Magento\TestFramework\Fixture\DataFixtureInterface;

/**
 * Assigning category to shared catalog
 */
class AssignCategory implements DataFixtureInterface
{
    private const CATEGORY = 'category';
    private const CATALOG_ID = 'catalog_id';

    /**
     * @var CategoryManagementInterface
     */
    private CategoryManagementInterface $categoryManagement;

    /**
     * @param CategoryManagementInterface $categoryManagement
     */
    public function __construct(
        CategoryManagementInterface $categoryManagement
    ) {
        $this->categoryManagement = $categoryManagement;
    }

    /**
     * @inheritdoc
     * @throws InvalidArgumentException|NoSuchEntityException
     */
    public function apply(array $data = []): ?DataObject
    {
        if (empty($data[self::CATALOG_ID])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATALOG_ID]));
        }

        if (empty($data[self::CATEGORY])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATEGORY]));
        }

        $this->categoryManagement->assignCategories((int)$data[self::CATALOG_ID], [$data[self::CATEGORY]]);

        return null;
    }
}
