<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model;

use Magento\Catalog\Api\Data\TierPriceInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Validate Tire Price data on request
 */
class PriceRequestValidator
{
    /**
     * @var array
     */
    private array $requiredFields;

    /**
     * Constructor
     *
     * @param array $requiredFields
     */
    public function __construct(
        array $requiredFields = []
    ) {
        $this->requiredFields = $requiredFields;
    }

    /**
     * Validate tire price request data
     *
     * @param TierPriceInterface[] $tierPrices
     * @throws LocalizedException
     */
    public function validate(array $tierPrices): void
    {
        foreach ($tierPrices as $tierPrice) {
            foreach ($this->requiredFields as $field => $method) {
                if ($tierPrice->$method() === null) {
                    $phrase = __(
                        'The validation of price request has failed: "%1" is required field.',
                        [$field]
                    );
                    throw new LocalizedException($phrase);
                }
            }
        }
    }
}
