<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model\Indexer\View;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\DB\Ddl\Trigger;
use Magento\Framework\Mview\View\Subscription;
use Magento\Framework\Mview\ViewInterface;

class SkuSubscription extends Subscription
{
    /**
     * @var array
     */
    private $processed;

    /**
     * @inheritdoc
     */
    public function getEntityColumn(string $prefix, ViewInterface $view): string
    {
        return '@entity_id';
    }

    /**
     * @inheritdoc
     */
    protected function buildStatement(string $event, ViewInterface $view): string
    {
        $statement = parent::buildStatement($event, $view);

        $preStatement = '';
        $triggerName = $this->resource->getTriggerName(
            $this->resource->getTableName($this->getTableName()),
            Trigger::TIME_AFTER,
            $event
        );
        if (!isset($this->processed[$triggerName])) {
            $connection = $this->resource->getConnection();
            $preStatement = vsprintf(
                'SET @entity_id = (SELECT %1$s FROM %2$s WHERE %3$s = %4$s.%5$s LIMIT 1);' . PHP_EOL,
                [
                    $connection->quoteIdentifier('entity_id'),
                    $connection->quoteIdentifier($this->resource->getTableName('catalog_product_entity')),
                    ProductInterface::SKU,
                    match ($event) {
                        Trigger::EVENT_INSERT, Trigger::EVENT_UPDATE => 'NEW',
                        Trigger::EVENT_DELETE => 'OLD',
                    },
                    $this->getColumnName()
                ]
            );
            $this->processed[$triggerName] = true;
        }
        $statement = sprintf('%sIF (@entity_id IS NOT NULL) THEN %s END IF;', $preStatement, $statement);

        return $statement;
    }
}
