<?php
/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 ******************************************************************************/
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Wishlist\Model\ResourceModel\Item;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Company\Model\CompanyContextFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\SharedCatalog\Model\CustomerGroupManagement;
use Magento\SharedCatalog\Model\State as SharedCatalogState;
use Magento\Wishlist\Model\ResourceModel\Item\Collection;

class WishlistItemCollectionPlugin
{
    /**
     * @param SharedCatalogState $sharedCatalogState
     * @param CompanyContextFactory $companyContextFactory
     * @param CustomerGroupManagement $customerGroupManagement
     * @param MetadataPool $metadataPool
     */
    public function __construct(
        private SharedCatalogState $sharedCatalogState,
        private CompanyContextFactory $companyContextFactory,
        private CustomerGroupManagement $customerGroupManagement,
        private MetadataPool $metadataPool
    ) {
    }

    /**
     * Apply shared catalog filter to wishlist items grid collection.
     *
     * @param Collection $subject
     * @param Collection $result
     * @return Collection
     * @throws LocalizedException
     */
    public function afterResetSortOrder(Collection $subject, $result)
    {
        if ($this->sharedCatalogState->isEnabled()) {
            $companyContext = $this->companyContextFactory->create();
            $customerGroupId = $companyContext->getCustomerGroupId();

            if (!$subject->hasFlag('has_shared_catalog_filter')
                && !$this->customerGroupManagement->isPrimaryCatalogAvailable($customerGroupId)) {

                $entityMetadata = $this->metadataPool->getMetadata(ProductInterface::class);
                $linkField = $entityMetadata->getLinkField();
                $result->getSelect()->joinInner(
                    ['e' => $subject->getTable('catalog_product_entity')],
                    "e.{$linkField} = main_table.product_id",
                    []
                )->joinInner(
                    ['shared_product' => $subject->getTable('shared_catalog_product_item')],
                    'shared_product.sku = e.sku',
                    'customer_group_id'
                )->where('shared_product.customer_group_id = ?', $customerGroupId);

                $subject->setFlag('has_shared_catalog_filter', true);
            }
        }
        return $result;
    }
}
