<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model;

use Magento\Framework\Exception\LocalizedException;
use Magento\SharedCatalog\Api\ResetTierPriceInterface;
use Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface;

/**
 * Manage tier price for shared catalog
 */
class ResetTierPrice implements ResetTierPriceInterface
{
    /**
     * @var SharedCatalogRepositoryInterface
     */
    private SharedCatalogRepositoryInterface $sharedCatalogRepository;

    /**
     * @var TierPriceManagement
     */
    private TierPriceManagement $sharedCatalogTierPriceManagement;

    /**
     * Constructor
     *
     * @param SharedCatalogRepositoryInterface $sharedCatalogRepository
     * @param TierPriceManagement $sharedCatalogTierPriceManagement
     */
    public function __construct(
        SharedCatalogRepositoryInterface $sharedCatalogRepository,
        TierPriceManagement $sharedCatalogTierPriceManagement,
    ) {
        $this->sharedCatalogRepository = $sharedCatalogRepository;
        $this->sharedCatalogTierPriceManagement = $sharedCatalogTierPriceManagement;
    }

    /**
     * @inheritdoc
     */
    public function execute(int $sharedCatalogId, array $skus): void
    {
        try {
            $sharedCatalog = $this->sharedCatalogRepository->get($sharedCatalogId);
            $this->sharedCatalogTierPriceManagement->deleteProductTierPrices($sharedCatalog, array_values($skus), true);
        } catch (\Exception $e) {
            throw new LocalizedException(__('Failed to reset custom prices for shared catalog'), $e);
        }
    }
}
