<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\ViewModel\Store;

use Magento\Authorization\Model\Role;
use Magento\Backend\Model\Auth\Session;
use Magento\SharedCatalog\ViewModel\Store\SwitcherAllowedValues;
use Magento\Store\Model\ResourceModel\Website\Collection;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;
use Magento\User\Model\User;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class SwitcherAllowedValuesTest extends TestCase
{
    /**
     * @var Role|MockObject
     */
    private $roleMock;

    /**
     * @var User|MockObject
     */
    private $userMock;

    /**
     * @var Session|MockObject
     */
    private $backendSessionMock;

    /**
     * @var Switcher
     */
    private $switcherModel;

    /**
     * @var CollectionFactory|MockObject
     */
    private $websiteCollectionFactoryMock;

    /**
     * @var Collection|MockObject
     */
    private $websiteCollectionMock;

    protected function setUp(): void
    {
        $this->userMock = $this->getMockBuilder(User::class)
            ->disableOriginalConstructor()
            ->onlyMethods(['getRole'])
            ->getMock();

        $this->roleMock = $this->getMockBuilder(Role::class)
            ->disableOriginalConstructor()
            ->addMethods(['getGwsIsAll', 'getGwsStoreGroups'])
            ->getMock();

        $this->backendSessionMock = $this->getMockBuilder(Session::class)
            ->disableOriginalConstructor()
            ->addMethods(['getUser'])
            ->getMock();

        $this->websiteCollectionMock = $this->getMockBuilder(Collection::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->websiteCollectionFactoryMock = $this->getMockBuilder(CollectionFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->websiteCollectionFactoryMock->expects($this->any())
            ->method('create')
            ->willReturn($this->websiteCollectionMock);

        $this->websiteCollectionMock->expects($this->any())
            ->method('getAllIds')
            ->willReturn([0, 1]);

        $this->switcherModel = new SwitcherAllowedValues(
            $this->backendSessionMock,
            $this->websiteCollectionFactoryMock
        );
    }

    /**
     * @return void
     */
    public function testGetSelectedOptionValue(): void
    {
        $storeGroupIds = ['1', '3'];

        $this->backendSessionMock->expects($this->once())
            ->method('getUser')
            ->willReturn($this->userMock);
        $this->userMock->expects($this->once())
            ->method('getRole')
            ->willReturn($this->roleMock);

        $this->roleMock->expects($this->once())
            ->method('getGwsIsAll')
            ->willReturn(0);

        $this->roleMock->expects($this->exactly(2))
            ->method('getGwsStoreGroups')
            ->willReturn($storeGroupIds);

        $this->switcherModel->getSelectedOptionValue();
    }
}
