<?php

/**
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * This file is added to preserve for backward compatibility with 2.4.6-x versions
 */

declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Framework\DataObject;
use Magento\TestFramework\Fixture\DataFixtureInterface;
use Magento\Indexer\Model\Indexer as IndexerModel;
use Magento\Indexer\Model\Indexer\Collection;

class Indexer implements DataFixtureInterface
{
    /**
     * @var Collection
     */
    private Collection $indexerCollection;

    /**
     * @param Collection $indexerCollection
     */
    public function __construct(
        Collection $indexerCollection
    ) {
        $this->indexerCollection = $indexerCollection;
    }

    /**
     * {@inheritdoc}
     * @param array $data Parameters
     */
    public function apply(array $data = []): ?DataObject
    {
        $this->indexerCollection->load();
        /** @var IndexerModel $indexer */
        foreach ($this->indexerCollection->getItems() as $indexer) {
            $indexer->reindexAll();
        }
        return null;
    }
}
