<?php
/**
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * This file is added to preserve for backward compatibility with 2.4.6-x versions
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Downloadable\Model;

use Magento\Downloadable\Api\Data\LinkInterface;
use Magento\Downloadable\Model\LinkRepository;
use Magento\Catalog\Api\ProductRepositoryInterface;

class LinkRepositoryPlugin
{
    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * Constructor
     *
     * @param ProductRepositoryInterface $productRepository
     */
    public function __construct(
        ProductRepositoryInterface $productRepository
    ) {
        $this->productRepository = $productRepository;
    }

    /**
     * Before save plugin to modify the product retrieval logic
     *
     * @param LinkRepository $subject
     * @param string $sku
     * @param LinkInterface $link
     * @param bool $isGlobalScopeContent
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeSave(
        LinkRepository $subject,
        $sku,
        LinkInterface $link,
        $isGlobalScopeContent = true
    ) {
        $this->productRepository->get($sku, true, null, true);

        return [$sku, $link, $isGlobalScopeContent];
    }
}
