<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Plugin\Catalog\Controller\Adminhtml\Product;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\Data\ProductTierPriceInterface;
use Magento\Catalog\Controller\Adminhtml\Product\Save as SaveController;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\SharedCatalog\Api\Data\SharedCatalogInterface;
use Magento\SharedCatalog\Plugin\Catalog\Controller\Adminhtml\Product\Save as SaveInterceptor;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\SharedCatalog\Api\Data\SearchResultsInterface;
use Magento\SharedCatalog\Api\ProductManagementInterface;
use Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface;
use Magento\SharedCatalog\Model\ProductSharedCatalogsLoader;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class SaveTest extends TestCase
{
    /**
     * @var ProductRepositoryInterface|MockObject
     */
    private ProductRepositoryInterface $productRepository;

    /**
     * @var SearchCriteriaBuilder|MockObject
     */
    private SearchCriteriaBuilder $searchCriteriaBuilder;

    /**
     * @var SharedCatalogRepositoryInterface|MockObject
     */
    private SharedCatalogRepositoryInterface $sharedCatalogRepository;

    /**
     * @var ProductSharedCatalogsLoader|MockObject
     */
    private ProductSharedCatalogsLoader $productSharedCatalogsLoader;

    /**
     * @var ProductManagementInterface|MockObject
     */
    private ProductManagementInterface $productSharedCatalogManagement;

    /**
     * @var SearchResultsInterface|MockObject
     */
    private SearchResultsInterface $searchResults;

    /**
     * @var SaveController
     */
    private SaveController $saveController;

    /**
     * @return void
     */
    protected function setUp(): void
    {
        $this->productRepository = $this->getMockForAbstractClass(ProductRepositoryInterface::class);

        $searchCriteria = $this->getMockForAbstractClass(SearchCriteriaInterface::class);
        $this->searchCriteriaBuilder = $this->createMock(SearchCriteriaBuilder::class);
        $this->searchCriteriaBuilder->method('addFilter')
            ->willReturnSelf();
        $this->searchCriteriaBuilder->method('create')
            ->willReturn($searchCriteria);
        $this->searchResults = $this->getMockForAbstractClass(SearchResultsInterface::class);

        $this->sharedCatalogRepository = $this->getMockForAbstractClass(SharedCatalogRepositoryInterface::class);
        $this->sharedCatalogRepository->method('getList')
            ->with($searchCriteria)
            ->willReturn($this->searchResults);

        $this->productSharedCatalogManagement = $this->getMockForAbstractClass(ProductManagementInterface::class);
        $this->productSharedCatalogsLoader = $this->createMock(ProductSharedCatalogsLoader::class);

        $this->saveController = $this->createMock(SaveController::class);
    }

    /**
     * @param array $sharedCatalogIds
     * @param array $tierPrices
     * @param array $assignedSharedCatalogIds
     * @param array $forAssignIds
     * @param array $forUnassignIds
     * @return void
     * @throws LocalizedException
     * @throws NoSuchEntityException
     *
     * @dataProvider executeDataProvider
     */
    public function testAroundExecute(
        array $sharedCatalogIds,
        array $tierPrices,
        array $assignedSharedCatalogIds,
        array $forAssignIds,
        array $forUnassignIds
    ): void {
        $productId = 1;
        $sku = 'sku1';

        $request = $this->createMock(RequestInterface::class);
        $request->expects($this->any())->method('getParam')->willReturnOnConsecutiveCalls(
            $productId,
            [
                ['tier_price' => $tierPrices],
                ['shared_catalog' => $sharedCatalogIds],
                'sku' => $sku
            ]
        );
        $this->saveController->expects($this->any())->method('getRequest')->willReturn($request);
        $oldProduct = $this->createMock(ProductInterface::class);
        $oldTierPrices = [];
        foreach ($tierPrices as $tierPrice) {
            $tierPriceObj = $this->createMock(ProductTierPriceInterface::class);
            $tierPriceObj->expects($this->once())->method('getCustomerGroupId')->willReturn($tierPrice);
            $oldTierPrices[] = $tierPriceObj;
        }
        $oldProduct->expects($this->once())->method('getTierPrices')->willReturn($oldTierPrices);
        $product = $this->createMock(ProductInterface::class);
        $product->method('getSku')
            ->willReturn($sku);
        $this->productRepository->expects($this->once())
            ->method('getById')
            ->with($productId)
            ->willReturn($oldProduct);
        $this->productRepository->expects($this->once())
            ->method('get')
            ->with($sku)
            ->willReturn($product);

        $sharedCatalogs = [];
        foreach ($forAssignIds as $id) {
            $sharedCatalogs[$id] = $this->getMockForAbstractClass(SharedCatalogInterface::class);
            $sharedCatalogs[$id]->method('getId')
                ->willReturn($id);
            $sharedCatalogs[$id]->method('getCustomerGroupId')
                ->willReturn($id);
        }
        $this->searchResults->method('getItems')
            ->willReturn($sharedCatalogs);

        $this->productSharedCatalogsLoader->expects($this->atLeastOnce())
            ->method('getAssignedSharedCatalogs')
            ->with($sku)
            ->willReturn(array_flip($assignedSharedCatalogIds));
        $this->productSharedCatalogManagement->expects($this->exactly(count($forAssignIds)))
            ->method('assignProducts')
            ->willReturn(true);
        $this->productSharedCatalogManagement->expects($this->exactly(count($forUnassignIds)))
            ->method('unassignProducts')
            ->willReturn(true);

        $saveInterceptor = new SaveInterceptor(
            $this->productRepository,
            $this->searchCriteriaBuilder,
            $this->sharedCatalogRepository,
            $this->productSharedCatalogsLoader,
            $this->productSharedCatalogManagement
        );
        $closure = function () {
            return true;
        };
        $saveInterceptor->aroundExecute($this->saveController, $closure);
    }

    /**
     * @return array
     */
    public function executeDataProvider(): array
    {
        return [
            [
                [],
                [],
                [],
                [],
                [],
            ],
            [
                [1, 2],
                [],
                [],
                [],
                [],
            ],
            [
                [],
                [],
                [1, 2],
                [],
                [1, 2],
            ],
            [
                [1, 2],
                [],
                [2, 3],
                [],
                [1, 2],
            ]
        ];
    }
}
