<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Api;

use Magento\Framework\Exception\LocalizedException;

/**
 * Reset tier prices
 *
 * @api
 */
interface ResetTierPriceInterface
{
    /**
     * Reset custom prices
     *
     * @param int $sharedCatalogId
     * @param string[] $skus
     * @return void
     * @throws LocalizedException
     */
    public function execute(int $sharedCatalogId, array $skus): void;
}
