<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\InvalidArgumentException;
use Magento\Framework\DataObject;
use Magento\SharedCatalog\Api\CompanyManagementInterface;
use Magento\TestFramework\Fixture\DataFixtureInterface;

/**
 * Assigning company to shared catalog
 */
class AssignCompany implements DataFixtureInterface
{
    private const COMPANY = 'company';
    private const CATALOG_ID = 'catalog_id';

    /**
     * @var CompanyManagementInterface
     */
    private CompanyManagementInterface $companyManagement;

    /**
     * @param CompanyManagementInterface $companyManagement
     */
    public function __construct(CompanyManagementInterface $companyManagement)
    {
        $this->companyManagement = $companyManagement;
    }

    /**
     * @inheritdoc
     * @throws InvalidArgumentException|NoSuchEntityException
     */
    public function apply(array $data = []): ?DataObject
    {
        if (empty($data[self::CATALOG_ID])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATALOG_ID]));
        }

        if (empty($data[self::COMPANY])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::COMPANY]));
        }

        $this->companyManagement->assignCompanies((int)$data[self::CATALOG_ID], [$data[self::COMPANY]]);

        return null;
    }
}
