<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Api;

use Magento\Catalog\Api\Data\TierPriceInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Assign tier prices to product
 *
 * @api
 */
interface AssignTierPriceInterface
{
    /**
     * Assign custom prices
     *
     * @param int $sharedCatalogId
     * @param TierPriceInterface[] $prices
     * @return void
     * @throws LocalizedException
     */
    public function execute(int $sharedCatalogId, array $prices): void;
}
