<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Plugin\Catalog\Model;

/**
 * Class for setting deny permissions for the new category.
 */
class DenyPermissionsForNewCategory
{
    /**
     * @var \Magento\SharedCatalog\Model\Config\CategoryPermission
     */
    private $configCategoryPermission;

    /**
     * @var \Magento\SharedCatalog\Model\CatalogPermissionManagement
     */
    private $catalogPermissionManagement;

    /**
     * @param \Magento\SharedCatalog\Model\CatalogPermissionManagement $catalogPermissionManagement
     * @param \Magento\SharedCatalog\Model\Config\CategoryPermission $configCategoryPermission
     */
    public function __construct(
        \Magento\SharedCatalog\Model\CatalogPermissionManagement $catalogPermissionManagement,
        \Magento\SharedCatalog\Model\Config\CategoryPermission $configCategoryPermission
    ) {
        $this->catalogPermissionManagement = $catalogPermissionManagement;
        $this->configCategoryPermission = $configCategoryPermission;
    }

    /**
     * Deny permissions for the new category if shared catalog and category permissions features are enabled
     *
     * @param \Magento\Catalog\Model\Category $subject
     * @param \Magento\Catalog\Model\Category $category
     * @return \Magento\Catalog\Model\Category
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterSave(
        \Magento\Catalog\Model\Category $subject,
        \Magento\Catalog\Model\Category $category
    ): \Magento\Catalog\Model\Category {
        if (empty($category->getPermissions()) && $this->configCategoryPermission->isConfigEnable()) {
            $this->catalogPermissionManagement->setDenyPermissionsForCategory($category->getId());
        }
        return $category;
    }
}
