<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\SharedCatalog\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\DB\Ddl\Table;

/**
 * Upgrade Schema
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $connection = $setup->getConnection();

        if (version_compare($context->getVersion(), '2.0.1', '<')) {
            $sharedCatalogTableName = $setup->getTable(InstallSchema::SHARED_CATALOG_TABLE_NAME);
            $adminUserTableName = $setup->getTable(InstallSchema::ADMIN_USER_TABLE_NAME);
            $wantedFKName = $setup->getFkName(
                $sharedCatalogTableName,
                'created_by',
                $adminUserTableName,
                'user_id'
            );

            $connection->dropForeignKey($sharedCatalogTableName, $wantedFKName);

            $connection->addForeignKey(
                $wantedFKName,
                $sharedCatalogTableName,
                'created_by',
                $adminUserTableName,
                'user_id',
                Table::ACTION_SET_NULL
            );
        }

        $setup->endSetup();
    }
}
