<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\SharedCatalog\Test\Unit\Model;

/**
 * Unit test for Merger model.
 */
class MergerTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var \Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory
     *      |\PHPUnit_Framework_MockObject_MockObject
     */
    private $operationListFactory;

    /**
     * @var \Magento\SharedCatalog\Model\Merger
     */
    private $merger;

    /**
     * Set up.
     *
     * @return void
     */
    protected function setUp()
    {
        $this->operationListFactory = $this
            ->getMockBuilder(\Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory::class)
            ->setMethods(['create'])
            ->disableOriginalConstructor()
            ->getMock();

        $objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);
        $this->merger = $objectManager->getObject(
            \Magento\SharedCatalog\Model\Merger::class,
            [
                'operationListFactory' => $this->operationListFactory,
            ]
        );
    }

    /**
     * Test for merge method.
     *
     * @return void
     */
    public function testMerge()
    {
        $topicName = 'topic.name';
        $messages = [$topicName => ['message1', 'message2']];
        $operationList = $this->getMockBuilder(\Magento\AsynchronousOperations\Api\Data\OperationListInterface::class)
            ->disableOriginalConstructor()->getMock();
        $this->operationListFactory->expects($this->once())
            ->method('create')->with(['items' => $messages[$topicName]])->willReturn($operationList);
        $this->assertEquals([$topicName => [$operationList]], $this->merger->merge($messages));
    }
}
