<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\SharedCatalog\Model;

/**
 * Merge messages from operations queue.
 */
class Merger implements \Magento\Framework\MessageQueue\MergerInterface
{
    /**
     * @var \Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory
     */
    private $operationListFactory;

    /**
     * @param \Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory $operationListFactory
     */
    public function __construct(
        \Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory $operationListFactory
    ) {
        $this->operationListFactory = $operationListFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function merge(array $messages)
    {
        $result = [];
        foreach ($messages as $topicName => $topicMessages) {
            $operationList = $this->operationListFactory->create(['items' => $topicMessages]);
            $result[$topicName] = [$operationList];
        }
        return $result;
    }
}
