/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'ko',
    'jquery',
    'Magento_Ui/js/grid/provider'
], function (ko, $, GridProvider) {
    'use strict';

    return GridProvider.extend({
        defaults: {
            isReloadLocked: ko.observable(false),
            unlockDefersQueue: [],
            listens: {
                isReloadLocked: 'resolveLocks'
            }
        },

        /**
         * @inheritDoc
         */
        reload: function (options) {
            return this.buildUnlockPromise()
                .then(this._super.bind(this, options));
        },

        /**
         * Resolve locks queue.
         */
        resolveLocks:  function  () {
            if (!this.isReloadLocked()) {
                this.unlockDefersQueue.forEach(function (defer) {
                    defer.resolve();
                });
                this.unlockDefersQueue = [];
            }
        },

        /**
         * Build unlock promise.
         *
         * @returns {jQuery.Promise}
         */
        buildUnlockPromise: function () {
            var defer = $.Deferred();

            this.unlockDefersQueue.push(defer);
            this.resolveLocks();

            return defer.promise();
        }
    });
});
