<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\SharedCatalog\Api;

use Magento\SharedCatalog\Api\Data\SharedCatalogInterface;

/**
 * Shared catalog prices actions.
 * @api
 */
interface PriceManagementInterface
{
    /**
     * Save product tier prices.
     *
     * @param SharedCatalogInterface $sharedCatalog
     * @param array $prices
     * @return $this
     */
    public function saveProductTierPrices(SharedCatalogInterface $sharedCatalog, array $prices);

    /**
     * Delete product tier prices.
     *
     * @param SharedCatalogInterface $sharedCatalog
     * @param array $skus
     * @return $this
     */
    public function deleteProductTierPrices(SharedCatalogInterface $sharedCatalog, array $skus);
}
