<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\SharedCatalog\Api\Data;

use Magento\Framework\Api\SearchResultsInterface as FrameworkSearchResultsInterface;

/**
 * Interface for Shared Catalog Product Item search results.
 * @api
 */
interface ProductItemSearchResultsInterface extends FrameworkSearchResultsInterface
{
    /**
     * Get Shared Catalog Product Item list.
     *
     * @return \Magento\SharedCatalog\Api\Data\ProductItemInterface[]
     */
    public function getItems();

    /**
     * Set Shared Catalog Product Item list.
     *
     * @param \Magento\SharedCatalog\Api\Data\ProductItemInterface[] $items
     * @return $this
     */
    public function setItems(array $items);
}
