/**
 * ServicesId client side validation rules
 *
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

require([
    'jquery',
    'mage/translate',
    'mage/validation'
], function ($) {
    'use strict';

    $.validator.addMethod('validate-uuid', function (v) {
        return (/^(?=.{1,50}$)[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*$/i.test(v));
    }, $.mage.__('Please enter a valid Instance ID.'));
});
