<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\ServicesId\Model\Config\Backend;

use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\App\Config\Value;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

/**
 * Environment config variable processor model
 *
 * @api
 */
class Environment extends Value
{
    /**
     * Config paths
     */
    const INSTANCE_ID_CONFIG_PATH = 'services_connector/services_id/instance_id';
    const ENVIRONMENT_CONFIG_PATH = 'services_connector/services_id/environment';

    /**
     * @var WriterInterface
     */
    private $configWriter;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param ScopeConfigInterface $config
     * @param TypeListInterface $cacheTypeList
     * @param WriterInterface $configWriter
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ScopeConfigInterface $config,
        TypeListInterface $cacheTypeList,
        WriterInterface $configWriter,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->configWriter = $configWriter;
        parent::__construct($context, $registry, $config, $cacheTypeList, $resource, $resourceCollection, $data);
    }

    /**
     * Clean cache, value was changed
     *
     * @return Value
     */
    public function afterSave() : Value
    {
        if ($this->getValue() === \Magento\ServicesId\Model\Config\Source\Environment::NON_PRODUCTION_VALUE) {
            $this->configWriter->delete(self::INSTANCE_ID_CONFIG_PATH);
        }
        return parent::afterSave();
    }
}
