<?php
/**
 * Copyright 2019 Adobe
 * All Rights Reserved.
 */

declare(strict_types=1);

namespace Magento\SalesRule\Model\Spi;

use Magento\SalesRule\Api\Exception\CodeRequestLimitException;

/**
 * Determine whether number of requests for coupon codes has reached a limit.
 * @api
 */
interface CodeLimitManagerInterface
{
    /**
     * Checks whether the request for a code was issued after reaching a limit.
     *
     * @param string $code
     * @throws CodeRequestLimitException If a limit has been reached.
     * @return void
     */
    public function checkRequest(string $code): void;
}
