<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSRMASync\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\AdobeCommerceEventsClient\Event\Processor\EventDataProcessorInterface;
use Magento\SaaSRMASync\Sync\RMARepository;

class RMACloseEventProcessor implements EventDataProcessorInterface
{
    private RMARepository $rmaRepository;

    public function __construct(RMARepository $rmaRepository)
    {
        $this->rmaRepository = $rmaRepository;
    }

    public function process(Event $event, array $eventData): array
    {

        if ($eventData['status'] == 'closed' && !isset($eventData->items[0]["updated_at"])) {
            $eventData = $this->fixEventDataWhenStatusIsClosed($eventData);
        }

        return $eventData;
    }

    private function fixEventDataWhenStatusIsClosed(array $eventData): array
    {

        $closedDate = $this->rmaRepository->findRecentClosedRMADate($eventData['entity_id']);

        foreach ($eventData['items'] as &$rmaItem) {
            $rmaItem['updated_at'] = $closedDate;
        }
        return $eventData;
    }
}
