<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSRMASync\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\AdobeCommerceEventsClient\Event\Processor\EventDataProcessorInterface;

class RMAEventFixQuantitiesProcessor implements EventDataProcessorInterface
{
    public function process(Event $event, array $eventData): array
    {
        return $this->fixQuantities($eventData);
    }

    private function fixQuantities(array $eventData): array
    {
        foreach ($eventData['items'] as &$rmaItem) {
            // Fix quantities to avoid sending them as strings
            $propertiesToFix = ['qty_authorized', 'qty_approved', 'qty_returned', 'qty_requested'];
            foreach ($propertiesToFix as $property) {
                if (isset($rmaItem[$property])) {
                    $rmaItem[$property] = intval($rmaItem[$property]);
                }
            }
        }
        return $eventData;
    }
}
