<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSRMASync\Test\Unit\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\SaaSRMASync\Event\RMAEventFixQuantitiesProcessor;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class RMAEventFixQuantitiesProcessorTest extends TestCase
{
    private RMAEventFixQuantitiesProcessor $fixQuantitiesProcessor;

    protected function setUp(): void
    {
        $this->fixQuantitiesProcessor = new RMAEventFixQuantitiesProcessor();
    }

    public function test_shouldReturnItemsFormatted_whenRMAEventToFixTriggered()
    {
        $event = $this->createMock(Event::class);

        $itemsReceived =  [
            [
                'entity_id' => '200',
                'order_item_id' => '400',
                'qty_requested' => '1.0000',
                'qty_authorized' => 1,
                'qty_approved' => null,
                'status' => 'pending'
            ]
        ];
        $eventData = [
            'entity_id' => '1',
            'order_id' => '100',
            'order_increment_id' => '00100',
            'items' => $itemsReceived,
        ];

        $itemsExpected = [
            [
                'entity_id' => '200',
                'order_item_id' => '400',
                'status' => 'pending',
                'qty_requested' => 1,
                'qty_authorized' => 1,
                'qty_approved' => null,
            ]
        ];

        $expectedResult = [
            'entity_id' => '1',
            'order_id' => '100',
            'order_increment_id' => '00100',
            'items' => $itemsExpected,
        ];

        $result = $this->fixQuantitiesProcessor->process($event, $eventData);

        $this->assertEquals($expectedResult, $result);
    }

}
