<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSRMASync\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\AdobeCommerceEventsClient\Event\Processor\EventDataProcessorInterface;
use Magento\SaaSRMASync\Sync\RMARepository;

class OrderUuidProcessor implements EventDataProcessorInterface
{
    private RMARepository $rmaRepository;
    public function __construct(RMARepository $rmaRepository)
    {
        $this->rmaRepository = $rmaRepository;
    }

    public function process(Event $event, array $eventData): array
    {
        $orderUuid = $this->rmaRepository->findOrderUuid($eventData['order_id']);
        if ($orderUuid) {
            $eventData['order_uuid'] = $orderUuid;
        }
        return $eventData;
    }
}
