<?php
declare(strict_types=1);

use Magento\SaaSRMASync\Event\RMAItemOptionProcessor;
use Magento\SaaSRMASync\Sync\RMARepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Magento\AdobeCommerceEventsClient\Event\Event;

class RMAItemOptionProcessorTest extends TestCase
{
    private RMARepository&MockObject $rmaRepositoryMock;

    private RMAItemOptionProcessor $rmaItemOptionProcessor;

    protected function setUp(): void
    {
        $this->rmaRepositoryMock = $this->createMock(RMARepository::class);
        $this->rmaItemOptionProcessor = new RMAItemOptionProcessor($this->rmaRepositoryMock);
    }

    public function test_shouldReturnOptions_whenRMAEventsTriggered()
    {
        $event = $this->createMock(Event::class);
        $eventData = [
            'entity_id' => '1',
            'order_id' => '100',
            'order_increment_id' => '00100',
            'items' => [
                [
                    'entity_id' => '200',
                    'order_item_id' => '400',
                ],
            ],
        ];

        $expectedResult = [
            'entity_id' => '1',
            'order_id' => '100',
            'order_increment_id' => '00100',
            'items' => [
                [
                    'entity_id' => '200',
                    'order_item_id' => '400',
                    'options' => [
                        [
                            'label' => 'Resolution',
                            'value' => 'Exchange',
                        ],
                    ],
                ]
            ]
        ];

        $this->rmaRepositoryMock->expects($this->once())
            ->method('findRMAItemOptions')
            ->with(['200'])
            ->willReturn([
                [
                    'entity_id' => '200',
                    'attribute_id' => '456',
                    'value_id' => '789',
                    'label' => 'Resolution',
                    'value' => 'Exchange',
                ],
            ]);

        $result = $this->rmaItemOptionProcessor->process($event, $eventData);

        $this->assertEquals($expectedResult, $result);
    }
}
