<?php
declare(strict_types=1);

namespace Magento\SaaSRMASync\Event;

use Magento\AdobeCommerceEventsClient\Event\Event;
use Magento\AdobeCommerceEventsClient\Event\Processor\EventDataProcessorInterface;
use Magento\SaaSRMASync\Sync\RMARepository;

class RMAItemOptionProcessor implements EventDataProcessorInterface
{
    private RMARepository $rmaRepository;

    public function __construct(RMARepository $rmaRepository)
    {
        $this->rmaRepository = $rmaRepository;
    }

    public function process(Event $event, array $eventData): array
    {
        $itemIds = array_map(fn ($rmaItem) => $rmaItem['entity_id'], $eventData['items']);
        $itemOptions = $this->rmaRepository->findRMAItemOptions($itemIds);
        $itemOptionsGroupedByItemId = $this->groupBy('entity_id', $itemOptions);

        foreach ($eventData['items'] as &$rmaItem) {
            $rmaItem['options'] = array_map([$this, 'map'], $itemOptionsGroupedByItemId[$rmaItem['entity_id']] ?? []);
        }

        return $eventData;
    }

    private function map(array $rmaOptionRecord): array
    {
        return [
            'label' => $rmaOptionRecord['label'],
            'value' => $rmaOptionRecord['value'],
        ];
    }

    private function groupBy(string $keyName, array $array): array
    {
        $result = [];
        foreach ($array as $element) {
            $result[$element[$keyName]][] = $element;
        }
        return $result;
    }
}

