# Development

Process is pretty well documented in
the [official docs](https://developer.adobe.com/commerce/events/get-started/installation/), if there's any doubt in the
following guide, refer to that source.

## CEF onboarding in Stage

Involves configuration in:

1. Adobe developer console in Stage.
2. Instance configuration.
3. Verification using [fake-order-generator](https://git.corp.adobe.com/commerce-domain-services/fake-order-generator)

### 1. Adobe developer console

1. Go to [Adobe Developer console in Stage](https://developer-stage.adobe.com/console/home):
    * On login, select CM Magento Stage organization.
2. Create a new project: Projects > Create new project button
    * Change the project name: click Edit project button (top right) > Project title
3. Setup I/O Management API:
    1. Add an API > click Adobe Services > select I/O Management API > next
    2. Select OAuth Server-to-Server > Save configured API
4. Setup Adobe I/O Events for Adobe Commerce
    1. Add an API > click Experience Cloud > select Adobe I/O Events for Adobe Commerce > next
    2. Select OAuth Server-to-Server > Save configured API
5. Download project's json:
    1. Go to the project home > click Download button (top right)

### 2. Adobe Commerce instance configuration

1. Change Adobe I/O events config to point to stage:
   ```bash
   bin/magento config:set adobe_io_events/integration/adobe_io_environment staging
   ```
2. Go to the instance admin page
3. Setup Adobe I/O events:
    1. Go to Stores > Configuration > Adobe Services > Adobe I/O Events.
    2. Select Adobe I/O Authorization Type.
    3. Copy the downloaded json from the Adobe developer console.
    4. Set any Adobe Commerce Instance ID.
    5. Click on Save config.
4. Create an Event Provider through shell using the following command:
   ```bash
   bin/magento events:create-event-provider --label "event_provider" --description "Event provider for Adobe Commerce"
   ```
   Copy the ID returned.
5. Finish Adobe I/O Events configuration:
    1. Go to Stores > Configuration > Adobe Services > Adobe I/O Events.
    2. In the General Configuration section, set the Adobe I/O Event Provider ID.
    3. In the Commerce event section, toggle Enabled to Yes.
    4. Set Merchant ID and Environment ID to any value.
    5. Click on Save config.
6. If is a Magento Cloud environment, see: https://developer.adobe.com/commerce/events/get-started/installation/#cloud-configuration

### 3. Verification

1. Register event:
   ```bash
   bin/magento events:subscribe observer.sales_order_save_after --fields=entity_id --force
   ```
2. Regenerate code:
   ```bash
   bin/magento events:generate:module && bin/magento setup:di:compile
   ```
3. Force event publication:
   ```bash
   bin/magento fake-order-generator:one && bin/magento cron:run
   ```
   Note `cron:run` is only needed if in your environment cron jobs are not running automatically.
4. Check event received
   in [Splunk's stage index](https://splunk.or1.adobe.net/en-GB/app/TA-magento_ui/search?q=search%20index%3Ddx_commerce_domain_orders_service_stage%20EventingConsumer&display.page.search.mode=smart&dispatch.sample_ratio=1&earliest=%40d&latest=now&display.page.search.showFields=1&sid=1685439688.27065_89D2A891-A57C-4842-88B4-B457CCFD3156):
   ```
   index=dx_commerce_domain_orders_service_stage EventingConsumer
   ```

## Debugging

* Events are persisted in `event_data` table:
  ```sql
  select * from event_data order by created_at desc\G;
  ```
* Filter `event_data_batch_send` in `cron.log` to check if the cron job is being executed.
  ```bash
  [2023-05-29T15:09:26.459762+00:00] report.INFO: Cron Job event_data_batch_send is missed at 2023-05-29 14:54:00 [] []
  [2023-05-29T15:09:26.469291+00:00] report.INFO: Cron Job event_data_batch_send is run [] []
  [2023-05-29T15:09:30.449679+00:00] report.INFO: Cron Job event_data_batch_send is successfully finished. Statistics: {"sum":3.9803829193115,"count":1,"realmem":2097152,"emalloc":1274456,"realmem_start":92798976,"emalloc_start":90331672} [] []
  ```
* Filter `events` in `system.log` you should see log traces related to events being published.
  ```bash 
  [2023-05-29T15:09:30.446953+00:00] report.INFO: Event data batch of 1 events was successfully published. [] [
  ```
