<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);
namespace Magento\SaaSOrderSync\Console\Command;

use Magento\AsynchronousOperations\Api\Data\DetailedBulkOperationsStatusInterface;

class OrderSyncBulkInfo
{
    /**
     * @var DetailedBulkOperationsStatusInterface detailed info for bulk
     */
    private DetailedBulkOperationsStatusInterface $bulkDetail;

    /**
     * @var int $bulkStatusId status of current bulk
     */
    private int $bulkStatusId;

    public function __construct(DetailedBulkOperationsStatusInterface $bulkDetail, int $bulkStatusId)
    {

        $this->bulkDetail    = $bulkDetail;
        $this->bulkStatusId = $bulkStatusId;
    }

    public function getBulkDetail(): DetailedBulkOperationsStatusInterface
    {
        return $this->bulkDetail;
    }

    public function getBulkStatusId(): int
    {
        return $this->bulkStatusId;
    }
}
