<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Console\Command;

use Magento\Framework\Console\Cli;
use Magento\Framework\Webapi\Exception as WebapiException;

use Magento\SaaSOrderSync\Api\OrderSync\OrderSyncManagerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CancelOrderSync extends Command
{
    private const COMMAND_NAME = 'saas:order-sync:cancel';

    private OrderSyncManagerInterface $orderSyncManager;
    private ResponseFormatter $responseFormatter;

    public function __construct(OrderSyncManagerInterface $orderSyncManager, ResponseFormatter $responseFormatter)
    {
        $this->orderSyncManager = $orderSyncManager;
        $this->responseFormatter = $responseFormatter;
        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName(self::COMMAND_NAME)
            ->setDescription('Cancel a SaaS order synchronization.')
            ->addArgument(
                'syncId',
                InputArgument::REQUIRED,
                'Sync id'
            );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $syncId = $input->getArgument('syncId');

        try {
            $response = $this->orderSyncManager->cancelOrderSync($syncId);
            $sync = $response->getOrderSync();

            $pretty = $this->responseFormatter->format($sync);
            $output->writeln("<info>$pretty</info>");

            return Cli::RETURN_SUCCESS;
        } catch (WebapiException $e) {
            $output->writeln("<error>{$e->getMessage()}</error>");
            return Cli::RETURN_FAILURE;
        }
    }
}
