<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Test\Unit\Core\Console\Command;

use Magento\AsynchronousOperations\Api\Data\OperationInterface;
use Magento\AsynchronousOperations\Model\BulkStatus\Detailed;
use Magento\AsynchronousOperations\Model\Operation;
use Magento\AsynchronousOperations\Model\OperationStatusValidator;
use Magento\Framework\Bulk\BulkSummaryInterface;
use Magento\SaaSOrderSync\Console\Command\OrderSyncBulkInfo;
use Magento\SaaSOrderSync\Console\Command\ResponseFormatter;
use Magento\SaaSOrderSync\Core\OrderSync\OrderSync;
use PHPUnit\Framework\TestCase;

class ResponseFormatterTest extends TestCase
{

    private ResponseFormatter $responseFormatter;
    public function setUp(): void
    {
        $this->responseFormatter = new ResponseFormatter();
    }

    public function test_shouldReturnAJsonWithBasicFields_whenNotBulk(): void
    {

        $testData = new OrderSync("syncId", "createdFrom", "createdTo", "clientCode", 1, 1, 1, "status");

        $result = $this->responseFormatter->format($testData);
        $this->assertEquals($this->getExpectedJsonWithoutBulkData(), $result);
    }

    public function test_shouldReturnAJsonWithBasicFieldsAndBulkData_whenAddedBulk(): void
    {

        $testData = new OrderSync("syncId", "createdFrom", "createdTo", "clientCode", 1, 1, 1, "status");

        $bulkDetail = new Detailed();
        $bulkDetail->setBulkId("bulkId");
        $bulkDetail->setOperationCount(1);

        $operationStatusValidatorMock = $this->createMock(OperationStatusValidator::class);

        $operation = new Operation($operationStatusValidatorMock);
        $operation->setId(1);
        $operation->setResultSerializedData('resultSerialized');
        $operation->setStatus(OperationInterface::STATUS_TYPE_COMPLETE);
        $operation->setErrorCode(0);
        $operation->setResultMessage('resultMessage');

        $operationsList[0] = $operation;
        $bulkDetail->setOperationsList($operationsList);

        $bulkData = new OrderSyncBulkInfo($bulkDetail, BulkSummaryInterface::NOT_STARTED);
        $result = $this->responseFormatter->format($testData, $bulkData);
        $this->assertEquals($this->getExpectedJsonWithBulkData(), $result);
    }

    /**
     * @return string
     */
    private function getExpectedJsonWithoutBulkData(): string
    {
        return '{
    "syncId": "syncId",
    "createdFrom": "createdFrom",
    "createdTo": "createdTo",
    "clientCode": "clientCode",
    "status": "status",
    "initialCount": 1,
    "processedCount": 1,
    "errorCount": 1
}';
    }

    private function getExpectedJsonWithBulkData(): string
    {
        return '{
    "syncId": "syncId",
    "createdFrom": "createdFrom",
    "createdTo": "createdTo",
    "clientCode": "clientCode",
    "status": "status",
    "initialCount": 1,
    "processedCount": 1,
    "errorCount": 1,
    "bulk": {
        "bulkId": "bulkId",
        "bulkStatus": "NOT_STARTED (0)",
        "operationCount": 1,
        "operations": [
            {
                "operationId": 1,
                "status": "COMPLETE (1)",
                "errorCode": 0,
                "resultMessage": "resultMessage",
                "resultSerializedData": null
            }
        ]
    }
}';
    }
}
