<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\OrderSync\Bulk;

use Magento\SaaSOrderSync\Api\OrderSync\Bulk\OperationProcessor;
use Magento\SaaSOrderSync\Api\Result;
use Magento\SaaSOrderSync\Core\CommerceDataExport\OrdersDataExporterAdapter;
use Magento\SaaSOrderSync\Core\SaaS\SaaSClientResolverInterface;

class SyncOrderAggregatesOperationProcessor implements OperationProcessor
{

    private OrdersDataExporterAdapter $ordersExporterAdapter;
    private SaaSClientResolverInterface $clientResolver;

    public function __construct(OrdersDataExporterAdapter $ordersExporterAdapter, SaaSClientResolverInterface $clientResolver)
    {
        $this->ordersExporterAdapter = $ordersExporterAdapter;
        $this->clientResolver = $clientResolver;
    }

    public function process(string $syncId, array $orderIds): Result
    {
        return Result::wrap(function () use ($syncId, $orderIds) {
            $this->ordersExporterAdapter->assignUuidsToOrderEntities($orderIds);
            $orders = $this->ordersExporterAdapter->exportCommerceOrderAggregates($orderIds);
            $syncClient = $this->clientResolver->createOrderSyncClient();

            return $syncClient->syncOrderBatch($syncId, $orders);
        });
    }

    public function order(): int
    {
        return OperationProcessor::HIGHEST_PRECEDENCE;
    }
}
