<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Core\SaaS;

use GuzzleHttp\Client;
use GuzzleHttp\Middleware;
use Magento\SaaSOrderSync\Core\OrderSync\SaaSClient as OrderSyncSaaSClient;
use Magento\ServicesConnector\Api\ClientResolverInterface;
use Psr\Http\Message\RequestInterface;

class SaaSClientResolver implements SaaSClientResolverInterface
{

    public function __construct(
        private readonly ClientResolverInterface $clientResolver,
        private readonly SaaSConfig              $saaSConfig,
        private readonly AuditMiddleware         $auditMiddleware,
    ) {
    }

    public function createOrderSyncClient(): OrderSyncSaaSClient
    {
        $syncUrl = $this->saaSConfig->getOrderServiceSyncUrl();
        return new OrderSyncSaaSClient($this->create(), $syncUrl);
    }

    private function create(): Client
    {
        return $this->clientResolver->createHttpClient(
            'Magento_SaaSOrderSync',
            $this->saaSConfig->getEnvironment(),
            middlewares: [
                $this->environmentIdHeaderMiddleware(),
                $this->auditMiddleware->create([
                    'sender' => 'Magento_SaaSOrderSync',
                    'destination' => 'comdomainsvc-order-service',
                    'type' => 'sales',
                ])]
        );
    }

    private function environmentIdHeaderMiddleware(): callable {
        $environmentId = $this->saaSConfig->getEnvironmentId();
        return Middleware::mapRequest(function (RequestInterface $request) use ($environmentId) {
            return $request
                ->withHeader('Magento-Environment-Id', $environmentId);
        });
    }
}
